using System; 
 using System.Collections.Generic; 
 using System.ComponentModel; using System.Data; 
 using System.Drawing; 
 using System.Linq; 
 using System.Text; using System.Windows.Forms; 
using System.Threading;
using PsgBase;
using PsgIntl;

namespace Products
{
    [EditorClass, ViewGrid]
    public partial class Products : Base
    {
        #region Members
        ProductsBE.ProductsDataTable table = new ProductsBE.ProductsDataTable();
        ProductsBE.ProductsRow rowA = null;
        #endregion

        #region Constructors

        public Products()
        {
            InitializeComponent();
        }

        public Products(ViewGrid _browser):base(_browser)
        {
            InitializeComponent();
        }

        public Products(LookupGrid _search):base(_search)
        {
            InitializeComponent();
        }

        #endregion Constructors

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);

            context.PsgFieldKey = "productid";
            context.PsgFieldDisplay = "productname";
            context.PsgCommand = "products";
            context.PsgServerTableName = "products";
        }

        public override void PsgStart()
        {
            base.PsgStart();

            AddTable("products", ID, "C");
            AddTable("suppliers", "null", "C");
            AddTable("categories", "null", "C");
            GetTables(this);           
        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);
            switch (this.alias_name.ToUpper())
            {
                case "SUPPLIERS":
                    cbSupplier.PsgComboTable = this.Intf.PsgTableServer;
                    cbSupplier.DataSource = cbSupplier.PsgComboTable;
                    cbSupplier.DisplayMember = "companyname";
                    cbSupplier.ValueMember = "supplierid";
                    break;  
                case "CATEGORIES":
                    cbCategory.PsgComboTable = this.Intf.PsgTableServer;
                    cbCategory.DataSource = cbCategory.PsgComboTable;
                    cbCategory.DisplayMember = "categoryname";
                    cbCategory.ValueMember = "categoryid";
                    break;
                case "PRODUCTS":
                    table = (ProductsBE.ProductsDataTable)SetMainData(dt, table);
                    rowA = (ProductsBE.ProductsRow)table.Rows[0];
                    break;
            }
        }

        public override void PsgBind()
        {
            BindEdit(edProductName, table.ProductNameColumn);
            BindCombo(cbSupplier, table.SupplierColumn, table.SupplierIDColumn);
            BindCombo(cbCategory, table.CategoryColumn, table.CategoryIDColumn);
            BindEdit(edQuantityPerUnit, table.QuantityPerUnitColumn);
            BindEdit(edUnitPrice, table.UnitPriceColumn);
            BindChecked(chkDiscontinued, table.DiscontinuedColumn);

            base.PsgBind();
        }

        public override void PsgView()
        {
            base.PsgView();

            this.ColumnsView(table.ProductNameColumn, GetIntl(Intl.Product));
            this.ColumnsView(table.SupplierColumn, GetIntl(Intl.Supplier));
            this.ColumnsView(table.CategoryColumn, GetIntl(Intl.Category));
            this.ColumnsView(table.QuantityPerUnitColumn, GetIntl(Intl.Quantity_per_unit), 200);
            this.ColumnsView(table.UnitPriceColumn, GetIntl(Intl.Unit_price));
            //this.ColumnsView(table.ReorderLevelColumn, GetIntl(Constants.Reorder_level));

            this.FiltersView(table.ProductNameColumn, GetIntl(Intl.Product));
            this.FiltersView(table.SupplierColumn, GetIntl(Intl.Supplier));
            this.FiltersView(table.CategoryColumn, GetIntl(Intl.Category));
            this.FiltersView(table.QuantityPerUnitColumn, GetIntl(Intl.Quantity_per_unit));
            this.FiltersView(table.UnitPriceColumn, GetIntl(Intl.Unit_price));
        }
    }
}